<?php
session_start(); require_once __DIR__ . '/Config.php'; require_once SRC_PATH . '/classes/LanguageController.php'; $languageController = LanguageController::getInstance(); if (isset($_GET['lang']) && in_array($_GET['lang'], $languageController->getAvailableLanguages())) { $languageController->setLanguage($_GET['lang']); } $_SESSION['from_menu'] = false; ?>
<!DOCTYPE html>
<html lang="<?php echo $languageController->getLanguage(); ?>" id="html-root">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TORRENT EMPIRE</title>
    <script>
        window.BASE_URL = '<?php echo BASE_URL; ?>';
        window.ASSETS_URL = '<?php echo ASSETS_URL; ?>';
        window.PUBLIC_URL = '<?php echo PUBLIC_URL; ?>';
        window.API_URL = '<?php echo API_URL; ?>';
        window.LANGUAGES_URL = '<?php echo LANGUAGES_URL; ?>';
    </script>
    <script src="<?php echo PUBLIC_URL; ?>/js/language.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/discord.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/protection.js"></script>
    <audio id="menu-music" loop>
        <source src="<?php echo ASSETS_URL; ?>/sounds/chase_in_the_night.wav" type="audio/wav">
        Your browser does not support the audio element.
    </audio>
    <script>
    (function(){
        const css = `
            html.effects-disabled .crt-glitch,
            html.effects-disabled .crt-flicker,
            html.effects-disabled .flicker,
            html.effects-disabled .color-shift {
                animation: none !important;
                -webkit-animation: none !important;
                opacity: 0 !important;
                transform: none !important;
                filter: none !important;
                box-shadow: none !important;
            }
        `;
        const style = document.createElement('style');
        style.id = 'effects-toggle-style';
        style.appendChild(document.createTextNode(css));
        document.head.appendChild(style);
    })();

    function setEffectsEnabled(enabled) {
        try { localStorage.setItem('effects_enabled', enabled ? '1' : '0'); } catch (e) {}
        if (enabled) {
            document.documentElement.classList.remove('effects-disabled');
        } else {
            document.documentElement.classList.add('effects-disabled');
        }
    }

    function loadEffectsSetting() {
        try {
            const val = localStorage.getItem('effects_enabled');
            if (val === null) return; 
            const enabled = (val === '1' || val === 'true');
            if (!enabled) document.documentElement.classList.add('effects-disabled');
        } catch (e) {}
    }
    
    function translatePageElements() {
        const elements = document.querySelectorAll('[data-i18n]');
        elements.forEach(element => {
            const key = element.getAttribute('data-i18n');
            const translation = window.langManager.translate(key);
            
            if (key === 'menu.security_notice') {
                const monitoredText = window.langManager.translate('menu.monitored');
                const recordedText = window.langManager.translate('menu.recorded');
                
                const params = {
                    monitored: `<span class="warning">${monitoredText}</span>`,
                    recorded: `<span class="warning">${recordedText}</span>`
                };
                
                let translatedText = translation;
                Object.keys(params).forEach(param => {
                    translatedText = translatedText.replace(`{${param}}`, params[param]);
                });
                
                element.innerHTML = translatedText;
                return;
            }
            
            if (key === 'menu.help_hint') {
                const helpCommand = window.langManager.translate('menu.commands.help');
                
                const params = {
                    command: `<span style="color: var(--accent-color)">${helpCommand}</span>`
                };
                
                let translatedText = translation;
                Object.keys(params).forEach(param => {
                    translatedText = translatedText.replace(`{${param}}`, params[param]);
                });
                
                element.innerHTML = translatedText;
                return;
            }
            
            const paramsAttr = element.getAttribute('data-i18n-params');
            if (paramsAttr) {
                try {
                    const params = JSON.parse(paramsAttr.replace(/'/g, '"'));
                    let translatedText = translation;
                    
                    Object.keys(params).forEach(param => {
                        translatedText = translatedText.replace(`{${param}}`, params[param]);
                    });
                    
                    element.innerHTML = translatedText;
                } catch (e) {
                    console.error('Error parsing i18n params:', e);
                    element.textContent = translation;
                }
            } else {
                element.textContent = translation;
            }
        });
    }
    
    document.addEventListener('DOMContentLoaded', function() {
        const serverLang = '<?php echo $languageController->getLanguage(); ?>';
        
        const initializeUI = () => {
            loadColorTheme();
            loadDisplayMode();

            initializeMenuMusic();
                loadEffectsSetting();
            
            if (window.DiscordRPC && window.DiscordRPC.isAvailable()) {
                window.DiscordRPC.setMenuPresence();
            }

            const commandInput = document.getElementById('command-input');
            const responseDiv = document.querySelector('.responses');
            
            if (commandInput) {
                commandInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        const command = commandInput.value.trim();

                        // color theme command
                        if (command.toLowerCase().startsWith('color ') || command.toLowerCase().startsWith('renk ') ||
                            command.toLowerCase() === 'color' || command.toLowerCase() === 'renk') {
                            const parts = command.split(' ');
                            const theme = parts.length > 1 ? parts[1].toLowerCase() : null;
                            handleColorCommand(theme, responseDiv);
                            commandInput.value = '';
                            e.preventDefault();
                            return;
                        }

                        // volume command
                        if (command.toLowerCase().startsWith('volume ') || command.toLowerCase().startsWith(window.langManager.translate('game.commands.volume').toLowerCase() + ' ')) {
                            const parts = command.split(' ');
                            if (parts.length > 1) {
                                const volume = parseFloat(parts[1]);
                                if (!isNaN(volume) && volume >= 0 && volume <= 1) {
                                    setMusicVolume(volume);
                                    displayCommandResponse(
                                        command,
                                        window.langManager.translate('game.music.volume_set') + ': ' + volume,
                                        responseDiv
                                    );
                                    commandInput.value = '';
                                    e.preventDefault();
                                    return;
                                } else {
                                    displayCommandResponse(
                                        command,
                                        window.langManager.translate('game.music.volume_invalid'),
                                        responseDiv
                                    );
                                    commandInput.value = '';
                                    e.preventDefault();
                                    return;
                                }
                            }
                        }

                        // effects on/off command
                        if (command.toLowerCase().startsWith('effects ') || command.toLowerCase() === 'effects') {
                            const parts = command.split(' ');
                            const arg = parts.length > 1 ? parts[1].toLowerCase() : '';
                            if (arg === 'on') {
                                setEffectsEnabled(true);
                                displayCommandResponse(command, window.langManager.translate('menu.commands.effects_on', 'Effects enabled'), responseDiv);
                            } else if (arg === 'off') {
                                setEffectsEnabled(false);
                                displayCommandResponse(command, window.langManager.translate('menu.commands.effects_off', 'Effects disabled'), responseDiv);
                            } else {
                                const current = (localStorage.getItem('effects_enabled') === '0' || localStorage.getItem('effects_enabled') === 'false') ? window.langManager.translate('menu.commands.effects_status_off','off') : window.langManager.translate('menu.commands.effects_status_on','on');
                                displayCommandResponse(command, window.langManager.translate('menu.commands.effects_usage', 'Usage: effects on|off. Current: {state}').replace('{state}', current), responseDiv);
                            }
                            commandInput.value = '';
                            e.preventDefault();
                            return;
                        }
                    }
                });
            }
            
            translatePageElements();
        };
        

        
        if (window.langManager) {
            window.langManager.loadLanguage(serverLang).then(() => {
                if (!window.langManager.translate('menu.domain.starting_with')) {
                    window.langManager.addTranslation('menu.domain.starting_with', 'Starting game with domain: {domain}');
                }
                
                setTimeout(initializeUI, 200);
                try {
                    const isDev = (function(){ try { return localStorage.getItem('torrent_devmode') === '1'; } catch(e){ return false; } })();
                    const warnEl = document.getElementById('menu-devmode-warning');
                    if (warnEl && isDev) {
                        warnEl.style.display = 'block';
                    } else if (warnEl) {
                        warnEl.style.display = 'none';
                    }
                } catch (e) {}
            });
        } else {
            setTimeout(() => {
                if (window.langManager) {
                    window.langManager.loadLanguage(serverLang).then(() => {
                        if (!window.langManager.translate('menu.domain.starting_with')) {
                            window.langManager.addTranslation('menu.domain.starting_with', 'Starting game with domain: {domain}');
                        }
                        
                        initializeUI();
                    });
                } else {
                    console.error('Language manager not available');
                    initializeUI();
                }
            }, 1000);
        }
    });

    function initializeMenuMusic() {
        const music = document.getElementById('menu-music');
        
        let savedVolume = localStorage.getItem('music_volume');
        if (savedVolume === null) {
            savedVolume = localStorage.getItem('game_music_volume') || localStorage.getItem('menu_music_volume');
        }
        
        if (savedVolume !== null) {
            savedVolume = parseFloat(savedVolume);
            if (!isNaN(savedVolume)) {
                music.volume = savedVolume;
                localStorage.setItem('music_volume', savedVolume.toString());
            } else {
                music.volume = 0.3; 
            }
        } else {
            music.volume = 0.3;
        }
        
        music.play().catch(error => {
        });
    }

    function setMusicVolume(volume) {
        const music = document.getElementById('menu-music');
        music.volume = volume;
        localStorage.setItem('music_volume', volume.toString());
        localStorage.setItem('menu_music_volume', volume.toString());
        localStorage.setItem('game_music_volume', volume.toString());
    }

    function displayCommandResponse(command, response, container) {
        const commandEntry = document.createElement('div');
        commandEntry.className = 'command-entry';

        const commandElement = document.createElement('div');
        commandElement.className = 'command';
        commandElement.textContent = '> ' + command;

        const responseElement = document.createElement('div');
        responseElement.className = 'command-response';
        
        if (typeof response === 'string' && response.startsWith('game.') || response.startsWith('menu.')) {
            try {
                responseElement.textContent = window.langManager.translate(response);
            } catch (e) {
                responseElement.textContent = response;
            }
        } else {
            responseElement.textContent = response;
        }

        commandEntry.appendChild(commandElement);
        commandEntry.appendChild(responseElement);
        container.appendChild(commandEntry);

        container.scrollTop = container.scrollHeight;
    }

    function loadColorTheme() {
        const savedTheme = localStorage.getItem('torrent_theme');
        if (savedTheme && savedTheme !== 'green') {
            const validThemes = ['blue', 'red', 'purple', 'amber', 'white'];
            if (validThemes.includes(savedTheme)) {
                document.documentElement.classList.add(`theme-${savedTheme}`);
                
                if (typeof matrixInterval !== 'undefined') {
                    clearInterval(matrixInterval);
                    matrixInterval = setInterval(drawMatrix, 35);
                }
            }
        }
    }

    function loadDisplayMode() {
        const savedMode = localStorage.getItem('display_mode');
        if (savedMode && typeof require !== 'undefined') {
            const { ipcRenderer } = require('electron');
            
            if (savedMode === 'windowed') {
                const savedBounds = localStorage.getItem('window_bounds');
                let bounds = null;
                if (savedBounds) {
                    try {
                        bounds = JSON.parse(savedBounds);
                    } catch (e) {
                        console.error('Failed to parse saved bounds:', e);
                    }
                }
                
                ipcRenderer.invoke('set-display-mode', savedMode, bounds).then(result => {
                    if (result.success) {
                        setupWindowBoundsListener();
                    }
                });
            } else {
                ipcRenderer.invoke('set-display-mode', savedMode).then(result => {
                    if (result.success) {
                    }
                });
            }
        }
    }
    
    function setupWindowBoundsListener() {
    }

    function handleColorCommand(theme, responseDiv) {
        const validThemes = ['green', 'blue', 'red', 'purple', 'amber', 'white'];
        
        if (!theme) {
            displayCommandResponse(
                'color',
                window.langManager.translate('color.usage', 'Kullanım: renk <tema>'),
                responseDiv
            );
            displayCommandResponse(
                '',
                window.langManager.translate('color.list_themes', 'Mevcut renk temaları:'),
                responseDiv
            );
            
            validThemes.forEach(t => {
                const themeName = window.langManager.translate(`color.themes.${t}`) || t;
                displayCommandResponse(
                    '',
                    `- ${t}: ${themeName}`,
                    responseDiv
                );
            });
            return;
        }
        
        if (!validThemes.includes(theme.toLowerCase())) {
            const themesString = validThemes.join(', ');
            displayCommandResponse(
                `color ${theme}`,
                window.langManager.translate('color.invalid_theme', {themes: themesString}) || `Geçersiz renk teması. Mevcut temalar: ${themesString}`,
                responseDiv
            );
            return;
        }
        
        const rootElement = document.documentElement;
        
        validThemes.forEach(t => {
            if (t !== 'green') {
                rootElement.classList.remove(`theme-${t}`);
            }
        });
        
        if (theme !== 'green') {
            rootElement.classList.add(`theme-${theme}`);
        }
        
        localStorage.setItem('torrent_theme', theme);
        
        clearInterval(matrixInterval);
        matrixInterval = setInterval(drawMatrix, 35);
    }
    </script>
    <style>
        @font-face {
            font-family: 'Share Tech Mono';
            src: url('<?php echo PUBLIC_URL; ?>/fonts/ShareTechMono-Regular.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
            font-display: swap;
        }

        @font-face {
            font-family: 'Orbitron';
            src: url('<?php echo PUBLIC_URL; ?>/fonts/Orbitron-Regular.ttf') format('truetype');
            font-weight: 400;
            font-style: normal;
            font-display: swap;
        }

        @font-face {
            font-family: 'Orbitron';
            src: url('<?php echo PUBLIC_URL; ?>/fonts/Orbitron-Bold.ttf') format('truetype');
            font-weight: 700;
            font-style: normal;
            font-display: swap;
        }
        
        :root {
            --primary-color: #0f0;
            --primary-color-rgb: 0, 255, 0;
            --secondary-color: #00ff9d;
            --secondary-color-rgb: 0, 255, 157;
            --accent-color: #00b3ff;
            --accent-color-rgb: 0, 179, 255;
            --warning-color: rgb(255, 94, 0);
            --warning-color-rgb: 255, 94, 0;
            --error-color: rgb(255, 0, 0);
            --error-color-rgb: 255, 0, 0;
            --text-shadow: 0 0 8px rgba(0, 255, 0, 0.8);
            --glow-shadow: 0 0 18px rgba(0, 255, 0, 0.6);
            --bg-color: #000806;
            --terminal-bg: rgba(0, 15, 10, 0.85);
            --scan-line-color: rgba(0, 255, 0, 0.1);
            --border-color: rgba(0, 255, 150, 0.3);
            --menu-btn-text: #000000;
            --btn-yes-bg: #28a745;
            --btn-no-bg: #dc3545;
            
            transition: --primary-color 0.3s, --secondary-color 0.3s, --accent-color 0.3s, 
                        --text-shadow 0.3s, --glow-shadow 0.3s, --terminal-bg 0.3s, 
                        --scan-line-color 0.3s, --border-color 0.3s;
        }
        
        .theme-blue {
            --primary-color: #00b3ff;
            --primary-color-rgb: 0, 179, 255;
            --secondary-color: #0088ff;
            --secondary-color-rgb: 0, 136, 255;
            --accent-color: #84d7ff;
            --accent-color-rgb: 132, 215, 255;
            --text-shadow: 0 0 8px rgba(0, 123, 255, 0.8);
            --glow-shadow: 0 0 18px rgba(0, 123, 255, 0.6);
            --bg-color: #000814;
            --terminal-bg: rgba(0, 8, 20, 0.85);
            --scan-line-color: rgba(0, 123, 255, 0.1);
            --border-color: rgba(0, 150, 255, 0.3);
            --menu-btn-text: #ffffff;
        }
        
        .theme-red {
            --primary-color: #ff0033;
            --primary-color-rgb: 255, 0, 51;
            --secondary-color: #ff5555;
            --secondary-color-rgb: 255, 85, 85;
            --accent-color: #ff8888;
            --accent-color-rgb: 255, 136, 136;
            --text-shadow: 0 0 8px rgba(255, 0, 0, 0.8);
            --glow-shadow: 0 0 18px rgba(255, 0, 0, 0.6);
            --bg-color: #140000;
            --terminal-bg: rgba(20, 0, 0, 0.85);
            --scan-line-color: rgba(255, 0, 0, 0.1);
            --border-color: rgba(255, 50, 50, 0.3);
            --menu-btn-text: #ffffff;
        }
        
        .theme-purple {
            --primary-color: #b300ff;
            --primary-color-rgb: 179, 0, 255;
            --secondary-color: #d355ff;
            --secondary-color-rgb: 211, 85, 255;
            --accent-color: #e088ff;
            --accent-color-rgb: 224, 136, 255;
            --text-shadow: 0 0 8px rgba(179, 0, 255, 0.8);
            --glow-shadow: 0 0 18px rgba(179, 0, 255, 0.6);
            --bg-color: #0c0014;
            --terminal-bg: rgba(12, 0, 20, 0.85);
            --scan-line-color: rgba(179, 0, 255, 0.1);
            --border-color: rgba(179, 50, 255, 0.3);
            --menu-btn-text: #000000;
        }
        
        .theme-amber {
            --primary-color: #ffb300;
            --primary-color-rgb: 255, 179, 0;
            --secondary-color: #ffc855;
            --secondary-color-rgb: 255, 200, 85;
            --accent-color: #ffdc88;
            --accent-color-rgb: 255, 220, 136;
            --text-shadow: 0 0 8px rgba(255, 179, 0, 0.8);
            --glow-shadow: 0 0 18px rgba(255, 179, 0, 0.6);
            --bg-color: #140c00;
            --terminal-bg: rgba(20, 12, 0, 0.85);
            --scan-line-color: rgba(255, 179, 0, 0.1);
            --border-color: rgba(255, 179, 50, 0.3);
            --menu-btn-text: #000000;
        }

        .theme-white {
            --primary-color: #e1e1e1;
            --primary-color-rgb: 225, 225, 225;
            --secondary-color: #ffffff;
            --secondary-color-rgb: 255, 255, 255;
            --accent-color: #b3e6ff;
            --accent-color-rgb: 179, 230, 255;
            --warning-color: rgb(255, 94, 0);
            --warning-color-rgb: 255, 94, 0;
            --error-color: rgb(255, 0, 0);
            --error-color-rgb: 255, 0, 0;
            --text-shadow: 0 0 8px rgba(220, 220, 220, 0.8);
            --glow-shadow: 0 0 18px rgba(220, 220, 220, 0.6);
            --bg-color: #101010;
            --terminal-bg: rgba(16, 16, 16, 0.85);
            --scan-line-color: rgba(220, 220, 220, 0.1);
            --border-color: rgba(220, 220, 220, 0.3);
            --menu-btn-text: #000000;
        }
        
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            width: 100%;
            overflow: hidden;
            background-color: var(--bg-color);
            font-family: 'Share Tech Mono', monospace;
            color: var(--primary-color);
            line-height: 1.5;
        }
        
        #matrix-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }
        
        .background-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at center, rgba(0, 15, 10, 0.4) 0%, rgba(0, 10, 6, 0.8) 70%, rgba(0, 5, 3, 0.9) 100%);
            z-index: -1;
        }
        
        .container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            padding: 20px;
            box-sizing: border-box;
            position: relative;
            z-index: 1;
        }

        .command-button {
            display: inline-block;
            padding: 8px 12px;
            margin: 6px 8px 6px 0;
            background: var(--secondary-color);
            color: var(--menu-btn-text);
            border: 1px solid rgba(255,255,255,0.06);
            border-radius: 4px;
            cursor: pointer;
            font-family: 'Share Tech Mono', monospace;
            font-size: 14px;
            text-align: center;
            user-select: none;
        }

        .lang-flag {
            width: 20px;
            height: 14px;
            object-fit: cover;
            vertical-align: middle;
            margin-right: 8px;
            border-radius: 2px;
            box-shadow: 0 0 0 1px rgba(0,0,0,0.12) inset;
        }

        .command-button:hover { filter: brightness(1.05); }

        .command-button.yes { background: var(--btn-yes-bg); color: #fff; border-color: rgba(0,0,0,0.2); }
        .command-button.no  { background: var(--btn-no-bg);  color: #fff; border-color: rgba(0,0,0,0.2); }

        .container button, .container .menu button { all: unset; display: inline-block; }
        .container button.command-button { display: inline-block; }

        #terminal-domain-submit.command-button {
        padding: 8px 15px !important;
        cursor: pointer !important;
        background: var(--btn-yes-bg) !important;
        color: #ffffff !important;
        border: 1px solid rgba(0,0,0,0.2) !important;
        border-radius: 4px;
    }
        
        .crt-monitor {
            position: relative;
            width: 90vw;
            max-width: 1200px;
            animation: monitorZoomIn 2s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
            transform-style: preserve-3d;
            perspective: 1000px;
        }
        
        @keyframes monitorZoomIn {
            0% {
                transform: scale(0.3) translateY(-30px);
                opacity: 0;
            }
            40% {
                opacity: 1;
            }
            70% {
                transform: scale(1.03) translateY(5px);
            }
            85% {
                transform: scale(0.98) translateY(-2px);
            }
            100% {
                transform: scale(1) translateY(0);
            }
        }
        
        .monitor-frame {
            background: linear-gradient(145deg, #2a2a2a 0%, #1a1a1a 50%, #0d0d0d 100%);
            border-radius: 20px;
            padding: 35px 35px 55px 35px;
            box-shadow: 
                0 20px 60px rgba(0, 0, 0, 0.8),
                inset 0 2px 4px rgba(255, 255, 255, 0.1),
                inset 0 -2px 4px rgba(0, 0, 0, 0.5);
            position: relative;
        }
        
        .monitor-frame::before {
            content: '';
            position: absolute;
            top: 8px;
            left: 8px;
            right: 8px;
            bottom: 40px;
            border-radius: 15px;
            background: linear-gradient(180deg, #333 0%, #1a1a1a 100%);
            z-index: 0;
        }
        
        .monitor-brand {
            position: absolute;
            bottom: 12px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            align-items: center;
            gap: 15px;
            z-index: 5;
        }
        
        .monitor-logo {
            font-family: 'Share Tech Mono', monospace;
            font-size: 12px;
            color: #555;
            text-transform: uppercase;
            letter-spacing: 3px;
            text-shadow: 0 1px 0 rgba(255,255,255,0.1);
        }
        
        .power-led {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: var(--primary-color);
            box-shadow: 0 0 10px var(--primary-color), 0 0 20px var(--primary-color);
            animation: ledPulse 2s ease-in-out infinite;
        }
        
        @keyframes ledPulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.6; }
        }
        
        .monitor-vents {
            position: absolute;
            bottom: 15px;
            right: 30px;
            display: flex;
            gap: 3px;
        }
        
        .vent-line {
            width: 20px;
            height: 2px;
            background: linear-gradient(90deg, #1a1a1a, #2a2a2a, #1a1a1a);
            border-radius: 1px;
        }
        
        .screen-bezel {
            background: #0a0a0a;
            border-radius: 12px;
            padding: 8px;
            position: relative;
            z-index: 1;
            box-shadow: 
                inset 0 0 30px rgba(0, 0, 0, 0.8),
                inset 0 0 5px rgba(var(--primary-color-rgb), 0.2);
        }
        
        .crt-screen {
            position: relative;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 
                inset 0 0 100px rgba(0, 0, 0, 0.5),
                0 0 20px rgba(var(--primary-color-rgb), 0.3);
        }
        
        .crt-screen::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(ellipse at center, transparent 0%, rgba(0,0,0,0.3) 90%, rgba(0,0,0,0.6) 100%);
            pointer-events: none;
            z-index: 100;
            border-radius: 8px;
        }
        
        .crt-screen::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                135deg,
                rgba(255, 255, 255, 0.03) 0%,
                transparent 50%
            );
            pointer-events: none;
            z-index: 101;
            animation: screenGlare 8s ease-in-out infinite;
        }
        
        @keyframes screenGlare {
            0%, 100% { transform: translateX(-10%) translateY(-10%); }
            50% { transform: translateX(10%) translateY(10%); }
        }
        
        .crt-scanlines {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: repeating-linear-gradient(
                0deg,
                rgba(0, 0, 0, 0.15) 0px,
                rgba(0, 0, 0, 0.15) 1px,
                transparent 1px,
                transparent 2px
            );
            pointer-events: none;
            z-index: 99;
            border-radius: 8px;
        }

        .crt-flicker {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(var(--primary-color-rgb), 0.02);
            pointer-events: none;
            z-index: 98;
            animation: crtFlicker 0.1s infinite;
            border-radius: 8px;
        }
        
        @keyframes crtFlicker {
            0% { opacity: 0.97; }
            50% { opacity: 1; }
            100% { opacity: 0.98; }
        }
        
        .screen-content {
            animation: powerOn 1.5s ease-out 1.8s both;
        }
        
        @keyframes powerOn {
            0% {
                opacity: 0;
                transform: scale(0.85) translateY(6px);
                filter: brightness(0) contrast(0.5) blur(6px);
                clip-path: inset(50% 0 50% 0);
            }
            25% {
                opacity: 1;
                transform: scale(0.9) translateY(0);
                filter: brightness(1.6) contrast(1.3) blur(3px);
                clip-path: inset(10% 0 10% 0);
            }
            55% {
                opacity: 1;
                transform: scale(1.02) translateY(0);
                filter: brightness(1.2) contrast(1.1) blur(1px);
                clip-path: inset(0 0 0 0);
            }
            100% {
                opacity: 1;
                transform: scale(1) translateY(0);
                filter: brightness(1) contrast(1) blur(0);
                clip-path: inset(0 0 0 0);
            }
        }
        
        .terminal {
            height: 75vh;
            background-color: var(--terminal-bg);
            border-radius: 8px;
            border: none;
            box-shadow: none;
            padding: 25px;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            backdrop-filter: blur(5px);
        }
        
        .social-icons {
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 20px;
        }
        
        .social-icon {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--terminal-bg);
            border: 1px solid var(--secondary-color);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .social-icon:hover {
            transform: translateY(-3px);
            box-shadow: 0 0 15px var(--glow-shadow);
            border-color: var(--accent-color);
        }
        
        .social-icon svg {
            width: 24px;
            height: 24px;
            fill: var(--secondary-color);
            transition: fill 0.3s ease;
        }
        
        .social-icon:hover svg {
            fill: var(--accent-color);
        }
        
        .social-icon::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at center, rgba(0, 255, 100, 0.1) 0%, transparent 70%);
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: -1;
        }
        
        .social-icon:hover::before {
            opacity: 1;
        }
        
        .social-icon::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: conic-gradient(transparent, var(--accent-color), transparent 30%);
            opacity: 0;
            transition: opacity 0.3s ease;
            animation: rotate 4s linear infinite;
            z-index: -2;
        }
        
        .social-icon:hover::after {
            opacity: 0.15;
        }
        
        @keyframes rotate {
            from {
                transform: rotate(0deg);
            }
            to {
                transform: rotate(360deg);
            }
        }
        
        .theme-blue .social-icon svg {
            fill: var(--secondary-color);
        }
        
        .theme-red .social-icon svg {
            fill: var(--secondary-color);
        }
        
        .theme-purple .social-icon svg {
            fill: var(--secondary-color);
        }
        
        .theme-amber .social-icon svg {
            fill: var(--secondary-color);
        }
        
        .theme-white .social-icon svg {
            fill: var(--secondary-color);
        }
        
        .scan-lines {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: repeating-linear-gradient(
                0deg,
                var(--scan-line-color),
                var(--scan-line-color) 2px,
                transparent 2px,
                transparent 4px
            );
            z-index: 1;
            pointer-events: none;
            opacity: 0.4;
        }
        
        .terminal-content {
            padding: 15px;
            flex: 1;
            z-index: 2;
            overflow-y: auto;
            scrollbar-width: thin;
            scrollbar-color: var(--secondary-color) transparent;
        }
        
        .terminal-content::-webkit-scrollbar {
            width: 6px;
        }
        
        .terminal-content::-webkit-scrollbar-track {
            background: transparent;
        }
        
        .terminal-content::-webkit-scrollbar-thumb {
            background-color: var(--secondary-color);
            border-radius: 10px;
        }
        
        .header {
            padding: 10px 15px;
            text-align: center;
            border-bottom: 1px solid var(--secondary-color);
            margin-bottom: 20px;
            position: relative;
            z-index: 2;
        }
        
        .header h1 {
            font-size: 28px;
            margin: 0;
            text-transform: uppercase;
            letter-spacing: 3px;
            text-shadow: var(--text-shadow);
            color: var(--secondary-color);
            animation: neonGlow 2s infinite alternate;
        }
        
        .header p {
            margin: 5px 0 0;
            font-size: 14px;
            opacity: 0.8;
        }
        
        .ascii-art {
            font-family: monospace;
            white-space: pre;
            line-height: 1.2;
            font-size: 12px;
            color: var(--accent-color);
            text-align: center;
            margin: 20px 0;
            text-shadow: 0 0 5px var(--accent-color);
        }
        
        .command-prompt {
            display: flex;
            border: 1px solid var(--secondary-color);
            margin-top: 20px;
            padding: 10px;
            background-color: var(--terminal-bg);
            border-radius: 5px;
            box-shadow: 0 0 10px var(--glow-shadow);
            position: relative;
            z-index: 2;
        }
        
        .prompt {
            color: var(--accent-color);
            margin-right: 10px;
            font-weight: bold;
            text-shadow: 0 0 5px var(--accent-color);
        }
        
        #command-input {
            flex: 1;
            background: transparent;
            border: none;
            color: var(--primary-color);
            font-family: 'Share Tech Mono', monospace;
            font-size: 16px;
            outline: none;
            caret-color: var(--primary-color);
            caret-shape: block;
        }
        
        .responses {
            margin: 20px 0;
        }
        
        .command-entry {
            margin-bottom: 10px;
            padding: 5px;
            border-radius: 3px;
        }
        
        .command-entry .command {
            color: var(--accent-color);
        }
        
        .command-response {
            margin-top: 5px;
            color: var(--primary-color);
        }
        
        .help-item {
            margin: 5px 0;
            padding: 5px;
            display: flex;
        }
        
        .help-command {
            color: var(--accent-color);
            min-width: 120px;
            font-weight: bold;
        }
        
        .help-desc {
            flex: 1;
        }
        
        .footer {
            text-align: center;
            font-size: 12px;
            padding: 10px;
            border-top: 1px solid var(--secondary-color);
            color: rgba(0, 255, 150, 0.7);
            position: relative;
            z-index: 2;
        }
        
        .blinking-cursor {
            display: inline-block;
            width: 10px;
            height: 20px;
            background-color: var(--primary-color);
            animation: blink 1s infinite;
            vertical-align: middle;
            margin-left: 2px;
        }
        
        .command-button {
            display: inline-block;
            margin: 10px 5px;
            padding: 8px 15px;
            background-color: var(--secondary-color);
            border: 1px solid rgba(0,0,0,0.12);
            color: var(--menu-btn-text);
            border-radius: 4px;
            cursor: pointer;
            font-family: 'Share Tech Mono', monospace;
            transition: all 0.12s ease-in-out;
            text-shadow: none;
            box-shadow: 0 2px 8px rgba(0,0,0,0.25);
        }

        .command-button:hover {
            filter: brightness(0.95);
            box-shadow: 0 4px 14px rgba(0,0,0,0.28);
            border-color: rgba(0,0,0,0.18);
        }
        
        .glitch-effect {
            position: relative;
            display: inline-block;
        }
        
        .warning {
            color: #ff5e00;
            text-shadow: 0 0 8px rgba(255, 94, 0, 0.8);
        }
        
        @keyframes blink {
            0%, 100% { opacity: 1; }
            50% { opacity: 0; }
        }
        
        @keyframes neonGlow {
            from {
                text-shadow: 0 0 5px var(--secondary-color), 0 0 10px var(--secondary-color);
            }
            to {
                text-shadow: 0 0 10px var(--secondary-color), 0 0 20px var(--secondary-color), 0 0 30px var(--secondary-color);
            }
        }
        
        @keyframes flicker {
            0%, 100% { opacity: 1; }
            92% { opacity: 1; }
            93% { opacity: 0.4; }
            94% { opacity: 0.6; }
            95% { opacity: 1; }
            96% { opacity: 0.8; }
            97% { opacity: 0.5; }
            98% { opacity: 0.9; }
            99% { opacity: 0.7; }
        }
        
        .flicker {
            animation: flicker 5s infinite;
        }
        
        .corner {
            position: absolute;
            width: 20px;
            height: 20px;
            z-index: 3;
        }
        
        .corner-tl {
            top: 0;
            left: 0;
            border-top: 2px solid var(--accent-color);
            border-left: 2px solid var(--accent-color);
            border-top-left-radius: 5px;
        }
        
        .corner-tr {
            top: 0;
            right: 0;
            border-top: 2px solid var(--accent-color);
            border-right: 2px solid var(--accent-color);
            border-top-right-radius: 5px;
        }
        
        .corner-bl {
            bottom: 0;
            left: 0;
            border-bottom: 2px solid var(--accent-color);
            border-left: 2px solid var(--accent-color);
            border-bottom-left-radius: 5px;
        }
        
        .corner-br {
            bottom: 0;
            right: 0;
            border-bottom: 2px solid var(--accent-color);
            border-right: 2px solid var(--accent-color);
            border-bottom-right-radius: 5px;
        }
        
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        
        .modal-content {
            background-color: var(--terminal-bg);
            border: 1px solid var(--border-color);
            box-shadow: 0 0 20px rgba(0, 255, 0, 0.3);
            width: 90%;
            max-width: 500px;
            color: var(--primary-color);
            text-shadow: var(--text-shadow);
            animation: modalAppear 0.3s ease-out;
            position: relative;
            margin: 0 auto;
        }
        
        @keyframes modalAppear {
            from { transform: scale(0.8); opacity: 0; }
            to { transform: scale(1); opacity: 1; }
        }
        
        .modal-header {
            background-color: rgba(0, 20, 10, 0.5);
            padding: 15px;
            border-bottom: 1px solid var(--border-color);
            font-size: 18px;
            text-align: center;
        }
        
        .modal-body {
            padding: 20px;
            text-align: center;
        }
        
        .modal-footer {
            padding: 15px;
            text-align: center;
            border-top: 1px solid var(--border-color);
        }
        
        .domain-input-container {
            margin: 20px 0;
        }
        
        .domain-input {
            background-color: rgba(0, 10, 5, 0.7);
            border: 1px solid var(--border-color);
            padding: 10px;
            width: 80%;
            color: var(--primary-color);
            font-family: 'Share Tech Mono', monospace;
            font-size: 16px;
            text-align: center;
        }
        
        .domain-input:focus {
            outline: none;
            box-shadow: 0 0 10px var(--primary-color);
        }
        
        .popup-button {
            display: inline-block;
            background-color: rgba(0, 20, 0, 0.7);
            color: var(--primary-color);
            border: 1px solid var(--border-color);
            padding: 8px 20px;
            margin: 0 5px;
            cursor: pointer;
            transition: all 0.3s;
            font-family: 'Share Tech Mono', monospace;
        }
        
        .popup-button:hover {
            background-color: rgba(0, 40, 0, 0.7);
            box-shadow: 0 0 10px var(--primary-color);
        }
        
        .popup-button.yes {
            background-color: rgba(0, 40, 0, 0.7);
        }
        
        .loading-screen {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: var(--terminal-bg);
            z-index: 1000;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            animation: loadingFadeIn 0.5s ease-out;
        }
        
        @keyframes loadingFadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .loading-screen.active {
            display: flex;
        }
        
        .loading-logo {
            font-family: 'Orbitron', 'Share Tech Mono', monospace;
            font-size: 2.5rem;
            font-weight: bold;
            color: var(--secondary-color);
            text-shadow: var(--text-shadow), 0 0 30px var(--primary-color);
            margin-bottom: 3rem;
            letter-spacing: 4px;
            position: relative;
        }
        
        .loading-logo::before,
        .loading-logo::after {
            content: '';
            position: absolute;
            height: 2px;
            background: linear-gradient(90deg, transparent, var(--primary-color), transparent);
            left: -20%;
            right: -20%;
        }
        
        .loading-logo::before {
            top: -15px;
        }
        
        .loading-logo::after {
            bottom: -15px;
        }
        
        .loading-spinner-container {
            position: relative;
            width: 120px;
            height: 120px;
            margin-bottom: 2rem;
        }
        
        .loading-spinner {
            position: absolute;
            width: 100%;
            height: 100%;
            border: 3px solid transparent;
            border-top-color: var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        .loading-spinner:nth-child(2) {
            width: 80%;
            height: 80%;
            top: 10%;
            left: 10%;
            border-top-color: var(--secondary-color);
            animation-duration: 1.5s;
            animation-direction: reverse;
        }
        
        .loading-spinner:nth-child(3) {
            width: 60%;
            height: 60%;
            top: 20%;
            left: 20%;
            border-top-color: var(--accent-color);
            animation-duration: 2s;
        }
        
        .loading-spinner-center {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 20px;
            height: 20px;
            background: var(--primary-color);
            border-radius: 50%;
            box-shadow: 0 0 20px var(--primary-color), 0 0 40px var(--primary-color);
            animation: pulse-glow 1s ease-in-out infinite alternate;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        @keyframes pulse-glow {
            from { box-shadow: 0 0 10px var(--primary-color), 0 0 20px var(--primary-color); }
            to { box-shadow: 0 0 20px var(--primary-color), 0 0 40px var(--primary-color), 0 0 60px var(--primary-color); }
        }
        
        .loading-progress-container {
            width: 80%;
            max-width: 400px;
            margin-bottom: 1.5rem;
        }
        
        .loading-progress-bar {
            height: 4px;
            background: rgba(var(--primary-color-rgb), 0.2);
            border-radius: 2px;
            overflow: hidden;
            position: relative;
        }
        
        .loading-progress-fill {
            height: 100%;
            width: 0%;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color), var(--primary-color));
            background-size: 200% 100%;
            animation: gradient-flow 1.5s linear infinite;
            transition: width 0.3s ease-out;
            box-shadow: 0 0 10px var(--primary-color);
        }
        
        @keyframes gradient-flow {
            0% { background-position: 0% 0; }
            100% { background-position: 200% 0; }
        }
        
        .loading-percentage {
            text-align: center;
            font-size: 1.2rem;
            color: var(--secondary-color);
            margin-top: 0.5rem;
            font-family: 'Orbitron', 'Share Tech Mono', monospace;
        }
        
        .loading-status {
            font-size: 0.95rem;
            color: var(--primary-color);
            text-shadow: var(--text-shadow);
            margin-top: 1rem;
            min-height: 1.5rem;
            text-align: center;
        }
        
        .loading-status::after {
            content: '';
            animation: loading-dots 1.5s infinite;
        }
        
        @keyframes loading-dots {
            0%, 20% { content: '.'; }
            40% { content: '..'; }
            60% { content: '...'; }
            80%, 100% { content: ''; }
        }
        
        .loading-hexagons {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            overflow: hidden;
            z-index: -1;
        }
        
        .hex {
            position: absolute;
            width: 60px;
            height: 70px;
            background: transparent;
            border: 1px solid rgba(var(--primary-color-rgb), 0.15);
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            animation: hex-float 8s ease-in-out infinite;
        }
        
        @keyframes hex-float {
            0%, 100% { transform: translateY(0) rotate(0deg); opacity: 0.3; }
            50% { transform: translateY(-20px) rotate(5deg); opacity: 0.5; }
        }
        
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translate(20px, -50%);
            }
            100% {
                opacity: 1;
                transform: translate(0, -50%);
            }
        }
        
        @media screen and (max-width: 1200px) {
            .monitor-frame {
                padding: 20px 20px 45px 20px;
            }
            
            .terminal {
                height: 70vh;
                padding: 20px;
            }
        }
        
        @media screen and (max-width: 900px) {
            .monitor-frame {
                padding: 15px 15px 40px 15px;
                border-radius: 15px;
            }
            
            .monitor-frame::before {
                border-radius: 10px;
                bottom: 35px;
            }
            
            .screen-bezel {
                padding: 6px;
                border-radius: 8px;
            }
            
            .terminal {
                height: 65vh;
                padding: 15px;
            }
            
            .monitor-logo {
                font-size: 10px;
            }
            
            .power-led {
                width: 6px;
                height: 6px;
            }
        }
        
        @media screen and (max-width: 600px) {
            .crt-monitor {
                width: 95%;
            }
            
            .monitor-frame {
                padding: 10px 10px 35px 10px;
                border-radius: 12px;
            }
            
            .terminal {
                height: 60vh;
                padding: 10px;
            }
            
            .ascii-art {
                font-size: 6px !important;
            }
        }
        /* Ensure menu/command buttons use bold text for readability */
        .command-button {
            font-weight: 700 !important;
        }

    </style>
</head>
<body>
    <div class="background-overlay"></div>
    <canvas id="matrix-bg"></canvas>
    
    <div class="container">
        <div class="crt-monitor">
            <div class="monitor-frame">
                <div class="screen-bezel">
                    <div class="crt-screen">
                        <div class="crt-scanlines"></div>
                        <div class="crt-flicker"></div>
                        <div class="screen-content">
                            <div class="terminal">
                                <div class="scan-lines"></div>
                                <div class="corner corner-tl"></div>
                                <div class="corner corner-tr"></div>
                                <div class="corner corner-bl"></div>
                                <div class="corner corner-br"></div>
                                
                                <div class="loading-screen" id="loading-screen">
                                    <div class="loading-hexagons" id="loading-hexagons"></div>
                                    <div class="loading-logo">TORRENT EMPIRE</div>
                                    <div class="loading-spinner-container">
                                        <div class="loading-spinner"></div>
                                        <div class="loading-spinner"></div>
                                        <div class="loading-spinner"></div>
                                        <div class="loading-spinner-center"></div>
                                    </div>
                                    <div class="loading-progress-container">
                                        <div class="loading-progress-bar">
                                            <div class="loading-progress-fill" id="loading-progress-fill"></div>
                                        </div>
                                        <div class="loading-percentage" id="loading-percentage">0%</div>
                                    </div>
                                    <div class="loading-status" id="loading-status">Initializing system</div>
                                </div>
                                
                                <div class="header">
                                    <p><span data-i18n="menu.version">v1.0.0 | CYBERSEC-AUTH://</span> <span id="ip-address">192.168.1.1</span></p>
                                </div>
            
            <div class="terminal-content">
                <div class="ascii-art">
 _____                           _      _____                 _          
|_   _|                         | |    |  ___|               (_)         
  | | ___  _ __ _ __ ___ _ __   | |_   | |__ _ __ ___  _ __  _ _ __ ___ 
  | |/ _ \| '__| '__/ _ \ '_ \  | __|  |  __| '_ ` _ \| '_ \| | '__/ _ \
  | | (_) | |  | | |  __/ | | | | |_   | |__| | | | | | |_| | | | |  __/
  \_/\___/|_|  |_|  \___|_| |_|  \__|  \____/_| |_| |_| .__/|_|_|  \___|
                                                       | |               
                                                       |_|               
                </div>
                
                <p data-i18n="menu.welcome">Welcome to the TORRENT EMPIRE terminal system.</p>
                <p id="security-notice-text" data-i18n="menu.security_notice">
                    All connections are <span class="warning" data-i18n="menu.monitored">MONITORED</span> and <span class="warning" data-i18n="menu.recorded">RECORDED</span>.
                </p>
                <p>
                    <span data-i18n="menu.help_hint">
                        Type <span style="color: var(--accent-color)">help</span> to see available commands.
                    </span>
                </p>
                <div id="menu-devmode-warning" style="margin-top:6px; display:none; background:#ff9800;color:#111;padding:8px;border-radius:6px;font-weight:600;"><div class="devmode-warning" data-i18n="menu.devmode.warning"></div></div>
                
                <div class="command-buttons">
                    <div class="command-button" onclick="executeCommand('help')" data-i18n="menu.commands.help">help</div>
                    <div class="command-button" onclick="clearResponsesAndExecuteCommand('start')" data-i18n="menu.commands.start">start</div>
                    <div class="command-button" onclick="executeCommand('load')" data-i18n="menu.commands.load">load</div>
                    <div class="command-button" onclick="executeCommand('language')" data-i18n="menu.commands.lang">language</div>
                    <div class="command-button" onclick="clearResponsesAndExecuteCommand('quit')" data-i18n="menu.commands.quit">quit</div>
                </div>
                
                <div class="responses" id="responses"></div>
            </div>
            
            <div class="command-prompt">
                <span class="prompt">root@torrent:~$</span>
                <input type="text" id="command-input" autocomplete="off" autofocus>
                <span class="blinking-cursor"></span>
            </div>
            
            <div class="footer">
                <span data-i18n="menu.copyright">TORRENT EMPIRE &copy; 2024 |</span>
                <span data-i18n="menu.connection">CONNECTION:</span>
                <span id="menu-secure" style="color: var(--accent-color)" data-i18n="menu.secure">SECURE</span>
                <span id="menu-dev-icon" style="margin-left:6px; display:inline-block;" title="" aria-hidden="true"></span>
                | 
                <span data-i18n="menu.ping">PING:</span>
                <span id="fake-ping">23</span><span data-i18n="menu.ms">ms</span>
            </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="monitor-brand">
                    <span class="monitor-logo">STEEL</span>
                    <div class="power-led"></div>
                </div>
                <div class="monitor-vents">
                    <div class="vent-line"></div>
                    <div class="vent-line"></div>
                    <div class="vent-line"></div>
                    <div class="vent-line"></div>
                </div>
            </div>
        </div>

        
        <div class="social-icons">
            <a href="https://store.steampowered.com/app/3703940/Torrent_Empire/" target="_blank" class="social-icon steam-icon" title="Steam">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512">
                    <path d="M496 256c0 137-111.2 248-248.4 248-113.8 0-209.6-76.3-239-180.4l95.2 39.3c6.4 32.1 34.9 56.4 68.9 56.4 39.2 0 71.9-32.4 70.2-73.5l84.5-60.2c52.1 1.3 95.8-40.9 95.8-93.5 0-51.6-42-93.5-93.7-93.5s-93.7 42-93.7 93.5v1.2L176.6 279c-15.5-.9-30.7 3.4-43.5 12.1L0 236.1C10.2 108.4 117.1 8 247.6 8 384.8 8 496 119 496 256zM155.7 384.3l-30.5-12.6a52.79 52.79 0 0 0 27.2 25.8c26.9 11.2 57.8-1.6 69-28.4 5.4-13 5.5-27.3.1-40.3-5.4-13-15.5-23.2-28.5-28.6-12.9-5.4-26.7-5.2-38.9-.6l31.5 13c19.8 8.2 29.2 30.9 20.9 50.7-8.3 19.9-31 29.2-50.8 21zm173.8-129.9c-34.4 0-62.4-28-62.4-62.3s28-62.3 62.4-62.3 62.4 28 62.4 62.3-27.9 62.3-62.4 62.3zm.1-15.6c25.9 0 46.9-21 46.9-46.8 0-25.9-21-46.8-46.9-46.8s-46.9 21-46.9 46.8c.1 25.8 21.1 46.8 46.9 46.8z"/>
                </svg>
            </a>
            <a href="https://discord.gg/jH8yE6fsf6" target="_blank" class="social-icon discord-icon" title="Discord">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512">
                    <path d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z"/>
                </svg>
            </a>
        </div>
    </div>

    <script>
        const canvas = document.getElementById('matrix-bg');
        const ctx = canvas.getContext('2d');
        
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        
        const chars = '01アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヲン';
        
        const fontSize = 14;
        const columns = Math.floor(canvas.width / fontSize);
        
        const drops = [];
        for (let i = 0; i < columns; i++) {
            drops[i] = Math.floor(Math.random() * -canvas.height);
        }
        
        function getCssVariable(variable) {
            return getComputedStyle(document.documentElement).getPropertyValue(variable).trim();
        }
        
        function getThemeColors() {
            return {
                primary: getCssVariable('--primary-color'),
                secondary: getCssVariable('--secondary-color'),
                accent: getCssVariable('--accent-color')
            };
        }
        
        function drawMatrix() {
            const colors = getThemeColors();
            
            ctx.fillStyle = 'rgba(0, 0, 0, 0.05)';
            ctx.fillRect(0, 0, canvas.width, canvas.height);

            ctx.font = fontSize + 'px monospace';
            
            for (let i = 0; i < drops.length; i++) {
                const char = chars[Math.floor(Math.random() * chars.length)];

                const x = i * fontSize;
                const y = drops[i] * fontSize;
                
                const colorVariation = Math.random();
                if (colorVariation < 0.1) {
                    ctx.fillStyle = colors.accent; 
                } else if (colorVariation > 0.9) {
                    ctx.fillStyle = colors.secondary; 
                } else {
                    ctx.fillStyle = colors.primary; 
                }
                
                ctx.fillText(char, x, y);
                
                drops[i]++;
                
                if (drops[i] * fontSize > canvas.height && Math.random() > 0.975) {
                    drops[i] = Math.floor(Math.random() * -20);
                }
            }
        }
        
        let matrixInterval = setInterval(drawMatrix, 35);
        
        document.addEventListener('DOMContentLoaded', function() {
            const commandInput = document.getElementById('command-input');
            const responses = document.getElementById('responses');
            
            document.getElementById('ip-address').textContent = `192.168.${Math.floor(Math.random() * 256)}.${Math.floor(Math.random() * 256)}`;
            
            setInterval(() => {
                document.getElementById('fake-ping').textContent = Math.floor(Math.random() * 50) + 10;
            }, 2000);
            
            document.querySelector('.terminal').addEventListener('click', (e) => {
                if (e.target.closest('.domain-entry-container')) {
                    return;
                }
                commandInput.focus();
            });
            
            commandInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    const command = commandInput.value.trim().toLowerCase();
                    if (command) {
                        executeCommand(command);
                    }
                    commandInput.value = '';
                }
            });
            
            window.executeCommand = function(command) {
                const commandElement = document.createElement('div');
                commandElement.className = 'command-entry';
                commandElement.innerHTML = `<div class="command"><span class="prompt">root@torrent:~$</span> ${command}</div>`;
                responses.appendChild(commandElement);
                
                processCommand(command, commandElement);
                
                document.querySelector('.terminal-content').scrollTop = document.querySelector('.terminal-content').scrollHeight;
            };
            
            window.clearResponsesAndExecuteCommand = function(command) {
                responses.innerHTML = '';
                
                executeCommand(command);
            };

            window.clearResponsesOnly = function() {
                const responsesEl = document.getElementById('responses');
                if (responsesEl) responsesEl.innerHTML = '';
                window.awaitingConfirmation = null;
                const commandInputEl = document.getElementById('command-input');
                if (commandInputEl) commandInputEl.focus();
                const terminalContent = document.querySelector('.terminal-content');
                if (terminalContent) terminalContent.scrollTop = terminalContent.scrollHeight;
            };
            
            function processCommand(command, commandElement) {
                const responseElement = document.createElement('div');
                responseElement.className = 'command-response';

                const commandParts = command.split(' ');
                const primaryCommand = commandParts[0].toLowerCase();

                
                
                const currentLang = window.langManager.getCurrentLanguage();
                const helpCommand = window.langManager.translate('menu.commands.help');
                const startCommand = window.langManager.translate('menu.commands.start');
                const loadCommand = window.langManager.translate('menu.commands.load');
                const quitCommand = window.langManager.translate('menu.commands.quit');
                const langCommand = window.langManager.translate('menu.commands.lang');
                const yesCommand = window.langManager.translate('menu.commands.yes');
                const noCommand = window.langManager.translate('menu.commands.no');
                
                let processedCommand = primaryCommand;
                
                if (primaryCommand === 'q') processedCommand = 'quit';
                else if (primaryCommand === 'y') processedCommand = 'yes';
                else if (primaryCommand === 'n') processedCommand = 'no';
                
                if (command === helpCommand && helpCommand !== 'help') processedCommand = 'help';
                if (command === startCommand && startCommand !== 'start') processedCommand = 'start';
                if (command === loadCommand && loadCommand !== 'load') processedCommand = 'load';
                if (command === quitCommand && quitCommand !== 'quit') processedCommand = 'quit';
                if (command === langCommand && langCommand !== 'language') processedCommand = 'language';
                if (command === yesCommand && yesCommand !== 'yes') processedCommand = 'yes';
                if (command === noCommand && noCommand !== 'no') processedCommand = 'no';
                
                const volumeCommand = window.langManager.translate('game.commands.volume');
                const colorCommand = window.langManager.translate('game.commands.color');
                
                if (primaryCommand === volumeCommand && volumeCommand !== 'volume') processedCommand = 'volume';
                if (primaryCommand === colorCommand && colorCommand !== 'color') processedCommand = 'color';
                
                switch (processedCommand) {
                    case 'devmode':
                        (function() {
                            const parts = command.split(' ').filter(Boolean);
                            const arg = parts.length > 1 ? parts[1].toLowerCase() : '';
                            const devResp = document.createElement('div');
                            devResp.className = 'command-response';
                            if (arg === 'on' || arg === '1') {
                                try { localStorage.setItem('torrent_devmode', '1'); } catch (e) {}
                                devResp.innerHTML = `<div>${window.langManager.translate('menu.devmode.enabled') || 'Dev Mode enabled. Starting or loading a game will mark this save as cheated.'}</div>`;
                                try {
                                    const warnEl = document.getElementById('menu-devmode-warning');
                                    if (warnEl) { warnEl.style.display = 'block'; }
                                } catch(e) {}
                            } else if (arg === 'off' || arg === '0') {
                                try { localStorage.setItem('torrent_devmode', '0'); } catch (e) {}
                                devResp.innerHTML = `<div>${window.langManager.translate('menu.devmode.disabled') || 'Dev Mode disabled.'}</div>`;
                                try {
                                    const warnEl = document.getElementById('menu-devmode-warning');
                                    if (warnEl) { warnEl.style.display = 'none'; }
                                } catch(e) {}
                                try {
                                    fetch(window.BASE_URL + '/src/utils/Index.php', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/x-www-form-urlencoded',
                                            'X-Requested-With': 'XMLHttpRequest'
                                        },
                                        body: 'action=clear_session_devmode'
                                    }).catch(() => {});
                                } catch(e) {}
                            } else {
                                devResp.innerHTML = `<div>${window.langManager.translate('menu.devmode.usage') || 'Usage: devmode &lt;on|off&gt;'}</div>`;
                            }
                            responses.appendChild(devResp);
                            document.querySelector('.terminal-content').scrollTop = document.querySelector('.terminal-content').scrollHeight;
                        })();
                        break;
                    case 'help':
                        responseElement.innerHTML = `
                            <div style="margin-bottom: 10px">${window.langManager.translate('menu.help.title')}</div>
                            <div class="help-item">
                                <div class="help-command">help</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.help_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">start</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.start_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">load</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.load_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">quit</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.quit_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">language</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.lang_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">volume [0-1]</div>
                                <div class="help-desc">${window.langManager.translate('game.commands.volume_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">color</div>
                                <div class="help-desc">${window.langManager.translate('game.commands.color_desc')}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">clear</div>
                                <div class="help-desc">${window.langManager.translate('game.commands.clear_desc') || 'Clear terminal responses (keeps static UI elements).'}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">fullscreen</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.fullscreen_desc') || 'Switch to fullscreen mode.'}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">windowed</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.windowed_desc') || 'Switch to windowed mode.'}</div>
                            </div>
                            <div class="help-item">
                                <div class="help-command">effects</div>
                                <div class="help-desc">${window.langManager.translate('menu.help.effects_desc') || 'Enable or disable visual effects.'}</div>
                            </div>
                        `;
                        break;
                        
                    case 'start':
                        responses.innerHTML = '';
                        
                        responses.appendChild(commandElement);
                        
                        responseElement.innerHTML = `
                            <div class="warning">${window.langManager.translate('menu.start.warning')}</div>
                            <p>${window.langManager.translate('menu.start.confirm')}</p>
                            <div class="command-button yes" onclick="executeCommand('${window.langManager.translate('menu.commands.yes')}')">${window.langManager.translate('menu.commands.yes')}</div>
                            <div class="command-button no" onclick="executeCommand('${window.langManager.translate('menu.commands.no')}')">${window.langManager.translate('menu.commands.no')}</div>
                        `;
                        commandElement.appendChild(responseElement);
                        window.awaitingConfirmation = 'start';
                        break;
                        
                    case 'yes':
                    case window.langManager.translate('menu.commands.yes').toLowerCase():
                    case 'y':
                    case window.langManager.translate('menu.commands.yes').toLowerCase().charAt(0):
                        if (window.awaitingConfirmation === 'quit') {
                            responseElement.innerHTML = `
                                <div>${window.langManager.translate('menu.quit.terminating')}</div>
                                <div class="warning">${window.langManager.translate('menu.quit.warning')}</div>
                            `;
                            commandElement.appendChild(responseElement);
                            
                            window.awaitingConfirmation = null;
                            
                            if (typeof sessionStorage !== 'undefined') {
                                sessionStorage.setItem('game_quitting', 'true');
                            }
                            
                            setTimeout(() => {
                                document.body.classList.add('terminal-shutdown');
                                
                                setTimeout(() => {
                                    window.close();
                                    document.body.innerHTML = `
                                        <div style="height: 100vh; display: flex; align-items: center; justify-content: center; background-color: #000806; color: #0f0; font-family: 'Share Tech Mono', monospace;">
                                            <div style="text-align: center;">
                                                <h1 style="color: #0f0; text-shadow: 0 0 10px rgba(0, 255, 0, 0.8);">${window.langManager.translate('menu.quit.connection_terminated')}</h1>
                                                <p>${window.langManager.translate('menu.quit.close_window')}</p>
                                            </div>
                                        </div>
                                    `;
                                }, 500);
                            }, 1000);
                            return;
                        } else if (window.awaitingConfirmation === 'start') {
                            responseElement.innerHTML = `
                                <div class="domain-entry-container">
                                    <div>${window.langManager.translate('menu.domain.description')}</div>
                                    <div style="display: flex; margin-top: 10px;">
                                        <input type="text" id="terminal-domain-input" placeholder="yourtorrent.org" 
                                            style="flex: 1; background-color: rgba(0,0,0,0.5); border: 1px solid var(--primary-color); 
                                            color: var(--primary-color); padding: 8px; font-family: 'Share Tech Mono', monospace;">
                                        <button id="terminal-domain-submit" class="command-button"
                                            style="margin-left: 10px;">
                                            ${window.langManager.translate('menu.domain.confirm')}
                                        </button>
                                    </div>
                                </div>
                            `;
                            commandElement.appendChild(responseElement);
                            
                            window.awaitingConfirmation = null;
                            
                            setTimeout(() => {
                                const terminalDomainInput = document.getElementById('terminal-domain-input');
                                const terminalDomainSubmit = document.getElementById('terminal-domain-submit');
                                
                                if (terminalDomainInput && terminalDomainSubmit) {
                                    terminalDomainInput.focus();
                                    
                                    terminalDomainSubmit.addEventListener('click', function() {
                                        submitTerminalDomain(terminalDomainInput.value);
                                    });
                                    
                                    terminalDomainInput.addEventListener('keydown', function(e) {
                                        if (e.key === 'Enter') {
                                            submitTerminalDomain(terminalDomainInput.value);
                                        }
                                    });
                                    
                                    const domainContainer = terminalDomainInput.closest('.domain-entry-container');
                                    if (domainContainer) {
                                        domainContainer.addEventListener('click', function(e) {
                                            e.stopPropagation();
                                            terminalDomainInput.focus();
                                        });
                                    }
                                }
                            }, 100);
                            
                            return;
                        } else {
                            responseElement.innerHTML = `<div>${window.langManager.translate('menu.errors.requires_context')}</div>`;
                        }
                        break;
                        
                    case 'no':
                    case window.langManager.translate('menu.commands.no').toLowerCase():
                    case 'n':
                    case window.langManager.translate('menu.commands.no').toLowerCase().charAt(0):
                        if (window.awaitingConfirmation) {
                            responseElement.innerHTML = `<div>${window.langManager.translate('menu.operation_cancelled')}</div>`;
                            window.awaitingConfirmation = null;
                        } else {
                            responseElement.innerHTML = `<div>${window.langManager.translate('menu.errors.requires_context')}</div>`;
                        }
                        break;
                        
                    case 'load':
                        responseElement.innerHTML = `<div>${window.langManager.translate('menu.load.checking')}</div>`;
                        commandElement.appendChild(responseElement);
                        
                        fetch(window.BASE_URL + '/src/utils/SystemT.php?action=check_save')
                            .then(response => response.json())
                            .then(data => {
                                const loadResponseElement = document.createElement('div');
                                loadResponseElement.className = 'command-response';
                                
                                if (data.exists) {
                                    loadResponseElement.innerHTML = `
                                        <div>${window.langManager.translate('menu.load.found')}</div>
                                    `;
                                    responses.appendChild(loadResponseElement);
                                    
                                    setTimeout(() => {
                                        showLoadingScreen('load_game');
                                    }, 500);
                                } else {
                                    loadResponseElement.innerHTML = `
                                        <div class="warning">${window.langManager.translate('menu.load.not_found')}</div>
                                        <div>${window.langManager.translate('menu.load.use_start')}</div>
                                    `;
                                }
                                
                                responses.appendChild(loadResponseElement);
                                document.querySelector('.terminal-content').scrollTop = document.querySelector('.terminal-content').scrollHeight;
                            })
                            .catch(error => {
                                const errorElement = document.createElement('div');
                                errorElement.className = 'command-response';
                                errorElement.innerHTML = `<div class="warning">${window.langManager.translate('menu.errors.save_check_failed', { error: error.message })}</div>`;
                                responses.appendChild(errorElement);
                                document.querySelector('.terminal-content').scrollTop = document.querySelector('.terminal-content').scrollHeight;
                            });
                        return;
                        
                    case 'quit':
                        responseElement.innerHTML = `
                            <div>${window.langManager.translate('menu.quit.confirm')}</div>
                            <div class="command-button yes" onclick="executeCommand('${window.langManager.translate('menu.commands.yes')}')">${window.langManager.translate('menu.commands.yes')}</div>
                            <div class="command-button no" onclick="executeCommand('${window.langManager.translate('menu.commands.no')}')">${window.langManager.translate('menu.commands.no')}</div>
                        `;
                        commandElement.appendChild(responseElement);
                        window.awaitingConfirmation = 'quit';
                        return;

                    case 'clear':
                        if (typeof window.clearResponsesOnly === 'function') {
                            window.clearResponsesOnly();
                        }
                        return;
                    
                    case 'language':
                        const availableLanguages = window.langManager.getAvailableLanguages();
                        let languageOptions = '';
                        
                            availableLanguages.forEach(lang => {
                                const flagSrc = (window.ASSETS_URL || '') + '/flags/' + lang.code + '.png';
                                languageOptions += `
                                    <div class="help-item">
                                        <div class="help-command"><img src="${flagSrc}" class="lang-flag" alt="${lang.code}" /> ${lang.code}</div>
                                        <div class="help-desc">${lang.name}</div>
                                    </div>
                                `;
                            });
                        
                        const currentLanguageName = window.langManager.translate(`menu.language.${currentLang}`);
                        
                        responseElement.innerHTML = `
                            <div>${window.langManager.translate('menu.language.current', { language: currentLanguageName })}</div>
                            <div style="margin: 10px 0">${window.langManager.translate('menu.language.title')}</div>
                            ${languageOptions}
                            <div style="margin-top: 10px">
                                ${availableLanguages.map(lang => {
                                    const flag = (window.ASSETS_URL || '') + '/flags/' + lang.code + '.png';
                                    return `<div class="command-button" onclick="changeLanguage('${lang.code}')"><img src="${flag}" class="lang-flag" alt="${lang.code}" /> ${lang.code}</div>`;
                                }).join('')}
                            </div>
                        `;
                        break;
                    
                        case 'volume':
                            if (commandParts.length > 1) {
                                const volumeValue = parseFloat(commandParts[1]);
                                if (!isNaN(volumeValue) && volumeValue >= 0 && volumeValue <= 1) {
                                    setMusicVolume(volumeValue);
                                    responseElement.innerHTML = `<div>${window.langManager.translate('game.music.volume_set')}: ${volumeValue}</div>`;
                                } else {
                                    responseElement.innerHTML = `<div>${window.langManager.translate('game.music.volume_invalid')}</div>`;
                                }
                            } else {
                                responseElement.innerHTML = `<div>${window.langManager.translate('game.music.volume_usage')}</div>`;
                            }
                            break;
                            
                        case 'color':
                            const validThemes = ['green', 'blue', 'red', 'purple', 'amber', 'white'];
                            
                            if (commandParts.length > 1) {
                                const theme = commandParts[1].toLowerCase();
                                
                                if (validThemes.includes(theme)) {
                                    handleColorCommand(theme, responses);
                                    const themeName = window.langManager.translate(`color.themes.${theme}`) || theme;
                                    responseElement.innerHTML = `<div>${window.langManager.translate('color.changed', { theme: themeName }) || `Renk teması değiştirildi: ${themeName}`}</div>`;
                                } else {
                                    const themesString = validThemes.join(', ');
                                    responseElement.innerHTML = `<div>${window.langManager.translate('color.invalid_theme', {themes: themesString}) || `Geçersiz renk teması. Mevcut temalar: ${themesString}`}</div>`;
                                }
                            } else {
                                let helpText = window.langManager.translate('color.usage', 'Kullanım: renk <tema>') + '<br>';
                                helpText += window.langManager.translate('color.list_themes', 'Mevcut renk temaları:') + '<br>';
                                
                                validThemes.forEach(t => {
                                    const themeName = window.langManager.translate(`color.themes.${t}`) || t;
                                    helpText += `- ${t}: ${themeName}<br>`;
                                });
                                
                                responseElement.innerHTML = `<div>${helpText}</div>`;
                            }
                            break;

                        case 'effects':
                            (function(){
                                const parts = commandParts.filter(Boolean);
                                const arg = parts.length > 1 ? parts[1].toLowerCase() : '';
                                if (arg === 'on') {
                                    try { localStorage.setItem('effects_enabled', '1'); } catch(e){}
                                    document.documentElement.classList.remove('effects-disabled');
                                    responseElement.innerHTML = `<div>${window.langManager.translate('menu.commands.effects_on','Effects enabled')}</div>`;
                                } else if (arg === 'off') {
                                    try { localStorage.setItem('effects_enabled', '0'); } catch(e){}
                                    document.documentElement.classList.add('effects-disabled');
                                    responseElement.innerHTML = `<div>${window.langManager.translate('menu.commands.effects_off','Effects disabled')}</div>`;
                                } else {
                                    const val = localStorage.getItem('effects_enabled');
                                    const isOff = (val === '0' || val === 'false');
                                    const state = isOff ? window.langManager.translate('menu.commands.effects_status_off','off') : window.langManager.translate('menu.commands.effects_status_on','on');
                                    responseElement.innerHTML = `<div>${window.langManager.translate('menu.commands.effects_usage','Usage: effects on|off. Current: {state}').replace('{state}', state)}</div>`;
                                }
                                commandElement.appendChild(responseElement);
                            })();
                            return;
                        
                        case 'fullscreen':
                            const { ipcRenderer: ipcFullscreen } = require('electron');
                            ipcFullscreen.invoke('set-display-mode', 'fullscreen').then(result => {
                                if (result.success) {
                                    localStorage.setItem('display_mode', 'fullscreen');
                                    responseElement.innerHTML = `<div>${window.langManager.translate('menu.display.fullscreen_enabled') || 'Switched to fullscreen mode.'}</div>`;
                                } else {
                                    responseElement.innerHTML = `<div class="warning">${result.error || 'Failed to switch mode.'}</div>`;
                                }
                                commandElement.appendChild(responseElement);
                            });
                            return;
                        
                        case 'windowed':
                            const { ipcRenderer: ipcWindowed } = require('electron');
                            ipcWindowed.invoke('set-display-mode', 'windowed').then(result => {
                                if (result.success) {
                                    localStorage.setItem('display_mode', 'windowed');
                                    if (result.bounds) {
                                        localStorage.setItem('window_bounds', JSON.stringify(result.bounds));
                                    }
                                    responseElement.innerHTML = `<div>${window.langManager.translate('menu.display.windowed_enabled') || 'Switched to windowed mode.'}</div>`;
                                    
                                    setupWindowBoundsListener();
                                } else {
                                    responseElement.innerHTML = `<div class="warning">${result.error || 'Failed to switch mode.'}</div>`;
                                }
                                commandElement.appendChild(responseElement);
                            });
                            return;
                        
                    default:
                        if (window.langManager.availableLanguages.includes(command)) {
                            changeLanguage(command);
                            return;
                        }

                                
                        
                        responseElement.innerHTML = `
                            <div class="warning">${window.langManager.translate('menu.errors.unknown_command', { command: command })}</div>
                            <div>${window.langManager.translate('menu.help_hint', { command: `<span style="color: var(--accent-color)">${helpCommand}</span>` })}</div>
                        `;
                }
                
                commandElement.appendChild(responseElement);
            }
            
            window.changeLanguage = function(lang) {
                window.langManager.loadLanguage(lang).then(() => {
                    const langName = window.langManager.translate(`menu.language.${lang}`);
                    
                    const commandElement = document.createElement('div');
                    commandElement.className = 'command-entry';
                    commandElement.innerHTML = `<div class="command"><span class="prompt">root@torrent:~$</span> ${lang}</div>`;
                    
                    const responseElement = document.createElement('div');
                    responseElement.className = 'command-response';
                    responseElement.textContent = window.langManager.translate('menu.language.change_to', { language: langName });
                    
                    commandElement.appendChild(responseElement);
                    responses.appendChild(commandElement);
                    
                    document.querySelector('.terminal-content').scrollTop = document.querySelector('.terminal-content').scrollHeight;
                    
                    translatePageElements();
                });
            };

            function showLoadingScreen(action, domain = '') {
                const loadingScreen = document.getElementById('loading-screen');
                const loadingHexagons = document.getElementById('loading-hexagons');
                const loadingProgress = document.getElementById('loading-progress-fill');
                const loadingPercentage = document.getElementById('loading-percentage');
                const loadingStatus = document.getElementById('loading-status');
                
                const terminal = document.querySelector('.terminal');
                const header = terminal.querySelector('.header');
                const terminalContent = terminal.querySelector('.terminal-content');
                const commandPrompt = terminal.querySelector('.command-prompt');
                const footer = terminal.querySelector('.footer');
                
                if (header) header.style.display = 'none';
                if (terminalContent) terminalContent.style.display = 'none';
                if (commandPrompt) commandPrompt.style.display = 'none';
                if (footer) footer.style.display = 'none';
                
                loadingHexagons.innerHTML = '';
                for (let i = 0; i < 15; i++) {
                    const hex = document.createElement('div');
                    hex.className = 'hex';
                    hex.style.left = Math.random() * 100 + '%';
                    hex.style.top = Math.random() * 100 + '%';
                    hex.style.animationDelay = Math.random() * 5 + 's';
                    hex.style.transform = `scale(${0.5 + Math.random() * 1})`;
                    loadingHexagons.appendChild(hex);
                }
                
                loadingScreen.classList.add('active');
                
                const statusMessages = [
                    window.langManager?.translate('startup.initializing_components') || 'Initializing system components',
                    window.langManager?.translate('startup.loading_core') || 'Loading core modules',
                    window.langManager?.translate('startup.establishing_connection') || 'Establishing secure connection',
                    window.langManager?.translate('startup.verifying_integrity') || 'Verifying system integrity',
                    window.langManager?.translate('startup.preparing_environment') || 'Preparing user environment',
                    window.langManager?.translate('startup.starting_empire') || 'Starting Torrent Empire'
                ];
                
                let progress = 0;
                let messageIndex = 0;
                
                const progressInterval = setInterval(() => {
                    progress += Math.random() * 3 + 1;
                    if (progress > 100) progress = 100;
                    
                    loadingProgress.style.width = progress + '%';
                    loadingPercentage.textContent = Math.floor(progress) + '%';
                    
                    const newIndex = Math.floor((progress / 100) * statusMessages.length);
                    if (newIndex !== messageIndex && newIndex < statusMessages.length) {
                        messageIndex = newIndex;
                        loadingStatus.textContent = statusMessages[messageIndex];
                    }
                    
                        if (progress >= 100) {
                        clearInterval(progressInterval);
                        loadingStatus.textContent = window.langManager?.translate('startup.system_ready') || 'System ready. Launching...';

                        setTimeout(() => {
                                const devParam = (function(){ try { return localStorage.getItem('torrent_devmode') === '1' ? '&devmode=1' : ''; } catch(e){ return ''; } })();
                                if (action === 'new_game') {
                                    window.location.href = window.BASE_URL + '/src/utils/Index.php?action=new_game&domain=' + encodeURIComponent(domain) + devParam;
                                } else if (action === 'load_game') {
                                    window.location.href = window.BASE_URL + '/src/utils/Index.php?action=load_game' + devParam;
                                }
                        }, 500);
                    }
                }, 80);
            }

            function submitTerminalDomain(domainValue) {
                const domain = domainValue.trim();
                
                if (domain.length < 3 || !domain.includes('.')) {
                    const responseElement = document.createElement('div');
                    responseElement.className = 'command-response';
                    responseElement.innerHTML = `<div class="warning">${window.langManager.translate('menu.domain.invalid') || 'Please enter a valid domain name'}</div>`;
                    responses.appendChild(responseElement);
                    document.querySelector('.terminal-content').scrollTop = document.querySelector('.terminal-content').scrollHeight;
                    return;
                }
                
                window.activeDomainInput = null;

                showLoadingScreen('new_game', domain);
            }

            window.submitTerminalDomain = submitTerminalDomain;
            window.showLoadingScreen = showLoadingScreen;

            if (window.langManager) {
                const defaultTranslations = window.langManager.translations.en || {};
                if (defaultTranslations) {
                    if (!defaultTranslations['menu.domain.starting_with']) {
                        defaultTranslations['menu.domain.starting_with'] = 'Starting game with domain: {domain}';
                    }
                }
            }
        });
    </script>
</body>
</html> 